

=================
**Quiz - 1**

**An administrator configures a switch port for 802.1X authentication. During the initial connection phase, the device connected to the port cannot access any network services. What is the MOST LIKELY reason for this behavior?**

A. The EAP method selected by the administrator is not supported by the supplicant.  
B. The controlled port is blocking all traffic except EAPOL messages until authentication is completed.  
C. The switch is not capable of translating EAPOL messages into RADIUS messages for the authentication server.  
D. The authentication server is rejecting EAP packets due to an unsupported media type.





---

### Correct Answer:

**B. The controlled port is blocking all traffic except EAPOL messages until authentication is completed.**

---

### Reason:

- **Option B** is correct because, by design, a controlled port in 802.1X authentication blocks all input traffic except for EAPOL (EAP over LAN) messages until the supplicant successfully authenticates. This is a key feature of 802.1X to ensure unauthorized devices cannot access network services.
- **Option A** is incorrect because the selection of an unsupported EAP method would prevent the authentication process itself, but this is unrelated to the default blocking behavior of the controlled port.
- **Option C** is incorrect because even if the switch fails to translate EAPOL to RADIUS, the port would still remain in its default state of blocking all traffic except EAPOL messages.
- **Option D** is incorrect because EAP is media-independent and the issue described is not related to the media type but to the behavior of the controlled port.










=================
**Quiz - 2**



**A network engineer is evaluating EAP for use in an enterprise authentication solution. Which of the following statements BEST describes EAP's role in the authentication process?**

A. EAP is a complete authentication protocol that directly validates user credentials.  
B. EAP is not an authentication protocol but rather a framework for transporting authentication information but does not perform authentication itself.  
C. EAP is limited to authentication in wireless networks and cannot be used in wired networks.  
D. EAP encrypts user credentials and directly exchanges them with the authentication server.

---

### Correct Answer:

**B. EAP is not an authentication protocol but rather a framework for transporting authentication information but does not perform authentication itself.**

---

### Reason:

- **Option B** is correct because EAP (Extensible Authentication Protocol) is not an authentication protocol itself but a transport mechanism that supports a variety of authentication methods. It facilitates the exchange of authentication data between the supplicant, authenticator, and authentication server.
- **Option A** is incorrect because EAP does not validate credentials directly; it relies on the authentication method chosen within the EAP framework to perform the actual authentication.
- **Option C** is incorrect because EAP is media-independent and can operate over both wired (802.3) and wireless (802.11) networks.
- **Option D** is incorrect because EAP does not inherently encrypt user credentials; encryption depends on the specific EAP method (e.g., EAP-TLS) used.





=================
**Quiz - 3**



**A network administrator is implementing an authentication system for an enterprise environment. The organization requires a secure method to authenticate users with digital certificates while protecting user identity and credentials. Which EAP method should the administrator choose?**

A. EAP-MD5  
B. EAP-TLS inside PEAP  
C. EAP-GTC  
D. EAP-MSCHAPv2 without tunneling




---

### Correct Answer:

**B. EAP-TLS inside PEAP**

---

### Reason:

- **Option B** is correct because **EAP-TLS** provides strong security through digital certificates for client and server authentication, while **PEAP** adds an encrypted tunnel to protect user identity and credentials. This combination satisfies the organization's requirements for security and identity protection.
- **Option A** is incorrect because **EAP-MD5** does not provide server authentication or identity protection, making it highly insecure and unsuitable for enterprise environments.
- **Option C** is incorrect because **EAP-GTC** transfers passwords or OTPs in cleartext, which is insecure unless tunneled inside a method like PEAP or EAP-FAST. Even then, it does not support digital certificates.
- **Option D** is incorrect because **EAP-MSCHAPv2** alone does not protect user identity and lacks the security provided by tunneling protocols like PEAP or EAP-FAST.








=================
**Quiz - 4**





**An organization requires an authentication method that supports one-time passwords (OTPs) while ensuring secure communication between the supplicant and the authentication server. Which of the following EAP methods BEST meets this requirement?**

A. EAP-GTC tunneled inside PEAP  
B. EAP-MD5  
C. EAP-TLS  
D. EAP-MSCHAPv2 without tunneling









---

### Correct Answer:

**A. EAP-GTC tunneled inside PEAP**

---

### Reason:

- **Option A** is correct because **EAP-GTC** supports one-time passwords (OTPs) for client authentication. When tunneled inside **PEAP**, it ensures a secure communication channel, protecting the transmitted credentials.
- **Option B** is incorrect because **EAP-MD5** does not support OTPs and lacks secure communication, making it unsuitable for this requirement.
- **Option C** is incorrect because **EAP-TLS** relies on digital certificates for authentication and does not support OTPs as client credentials.
- **Option D** is incorrect because **EAP-MSCHAPv2** without tunneling does not provide secure communication and is not designed to handle OTPs.









=================
**Quiz - 5**



**A company needs an authentication solution that supports both device (machine) authentication and user authentication in the same EAP session. Which EAP method is the MOST suitable for this requirement?**

A. EAP-TLS  
B. EAP-MSCHAPv2 tunneled inside PEAP  
C. EAP-FAST  
D. EAP-GTC without tunneling








---

### Correct Answer:

**C. EAP-FAST**

---

### Reason:

- **Option C** is correct because **EAP-FAST** supports **EAP Chaining**, which allows simultaneous authentication of both the user and the device (machine) within a single EAP session. This capability is essential for environments requiring enhanced security for endpoints.
- **Option A** is incorrect because **EAP-TLS** provides strong authentication using digital certificates but does not support EAP Chaining for user and machine authentication in the same session.
- **Option B** is incorrect because while **EAP-MSCHAPv2** inside **PEAP** provides identity protection and secure password authentication, it does not support EAP Chaining.
- **Option D** is incorrect because **EAP-GTC** does not natively provide secure communication or EAP Chaining and is insecure unless tunneled.







=================
**Quiz - 6**




**An enterprise is deploying an EAP method that requires robust security using digital certificates for both client and server authentication. The method must not rely on tunneling. Which EAP method should the organization select?**

A. EAP-MSCHAPv2  
B. EAP-TLS  
C. EAP-FAST  
D. EAP-GTC tunneled inside PEAP







---

### Correct Answer:

**B. EAP-TLS**

---

### Reason:

- **Option B** is correct because **EAP-TLS** is a non-tunnel EAP method that provides strong mutual authentication using digital certificates for both the client and the server. It leverages public key cryptography and requires a Public Key Infrastructure (PKI) for certificate management, making it highly secure.
- **Option A** is incorrect because **EAP-MSCHAPv2** uses passwords and is less secure than certificate-based methods. It does not require digital certificates for client and server authentication.
- **Option C** is incorrect because **EAP-FAST** is a tunneled EAP method and requires additional configuration, such as Protected Access Credentials (PAC), for secure communication.
- **Option D** is incorrect because **EAP-GTC** does not natively support digital certificates and requires tunneling (e.g., inside PEAP) to provide secure communication.







=================
**Quiz - 7**





**A network administrator is tasked with selecting an EAP method for an enterprise environment. The method must provide protection for user identity during authentication and support password-based authentication with integration into Microsoft Active Directory. Which EAP method is the MOST appropriate?**

A. EAP-MD5  
B. EAP-MSCHAPv2 inside PEAP  
C. EAP-TLS  
D. EAP-GTC without tunneling








---

### Correct Answer:

**B. EAP-MSCHAPv2 inside PEAP**

---

### Reason:

- **Option B** is correct because **EAP-MSCHAPv2** provides password-based authentication and can integrate with Microsoft Active Directory. When tunneled inside **PEAP**, it protects user identity and credentials by creating a secure TLS channel. This combination is widely used in enterprise environments.
- **Option A** is incorrect because **EAP-MD5** does not provide identity protection or server authentication, making it insecure for enterprise use.
- **Option C** is incorrect because **EAP-TLS** uses digital certificates for authentication, not passwords, and requires a Public Key Infrastructure (PKI), which is outside the stated requirements.
- **Option D** is incorrect because **EAP-GTC** transfers credentials in cleartext unless tunneled, and it does not natively integrate with Active Directory.







=================
**Quiz - 8**



**In an 802.1X deployment, how does the authenticator communicate EAP messages to the authentication server when they are on different network layers?**

A. The authenticator encapsulates EAP messages inside RADIUS packets for Layer 3 transport.  
B. The authenticator directly forwards EAPOL messages from the supplicant to the authentication server.  
C. The authenticator translates EAP messages into TCP packets for transport to the authentication server.  
D. The authenticator uses a vendor-specific protocol to relay EAP messages to the authentication server.






---

### Correct Answer:

**A. The authenticator encapsulates EAP messages inside RADIUS packets for Layer 3 transport.**

---

### Reason:

- **Option A** is correct because, in an 802.1X architecture, the authenticator (e.g., a switch or wireless access point) encapsulates EAP messages into RADIUS packets for communication with the authentication server. This process is essential because the authentication server typically operates at Layer 3, while EAPOL messages between the supplicant and the authenticator occur at Layer 2.
- **Option B** is incorrect because EAPOL messages are only used for Layer 2 communication between the supplicant and the authenticator. They cannot be directly forwarded to the authentication server.
- **Option C** is incorrect because EAP messages are not translated into TCP packets; instead, they are encapsulated within RADIUS for Layer 3 transport.
- **Option D** is incorrect because the transport of EAP messages in 802.1X relies on the RADIUS protocol, not a vendor-specific protocol.









=================
**Quiz - 9**



**A network administrator is troubleshooting an 802.1X deployment where authentication requests are failing. Despite valid credentials, the RADIUS server logs indicate it cannot identify the device requesting authentication. Which RADIUS attribute is MOST LIKELY missing or misconfigured in the Access-Request packet?**

A. User-Name (Attribute 1)  
B. NAS-Identifier (Attribute 32)  
C. Called-Station-Id (Attribute 30)  
D. NAS-Port (Attribute 5)



---

### Correct Answer:

**B. NAS-Identifier (Attribute 32)**

---

### Reason:

- **Option B** is correct because the **Network Access Server** or the Authenticator (Radius Client) **NAS-Identifier (Attribute 32)** specifies the identity of the NAS (Network Access Server) requesting the authentication. If this attribute is missing or incorrect in the Access-Request packet, the RADIUS server cannot associate the request with the NAS, causing the authentication to fail. Alternatively, the NAS-IP-Address (Attribute 4) could be used, but one of these must be present.
- **Option A** is incorrect because **User-Name (Attribute 1)** identifies the user, not the NAS. The issue described is related to device identification, not user credentials.
- **Option C** is incorrect because **Called-Station-Id (Attribute 30)** stores the MAC address of the authenticator, not its identity as a NAS. This attribute alone cannot resolve the issue.
- **Option D** is incorrect because **NAS-Port (Attribute 5)** specifies the physical port on the NAS but does not uniquely identify the NAS itself.








=================
**Quiz - 10**



**During an 802.1X authentication process, a supplicant showing high enthusiasm introduces itself to the network by shouting, "Hey! I'm here!" (in the form of a packet). What is the technical name for this extrovert greeting?**

A. EAPOL-Start  
B. Access-Request  
C. Access-Challenge  
D. Supplicant-Handshake







---

### Correct Answer:

**A. EAPOL-Start**

---

### Reason:

- **Option A** is correct because the **EAPOL-Start** frame is sent by the supplicant to the authenticator to initiate the authentication process. It's like the supplicant saying, "Hey, let's get this authentication party started!"
- **Option B** is incorrect because the **Access-Request** packet is sent by the authenticator to the RADIUS server, not by the supplicant.
- **Option C** is incorrect because the **Access-Challenge** packet is sent by the RADIUS server to request additional information, not by the supplicant.
- **Option D** is incorrect because "Supplicant-Handshake" is made-up and doesn't exist in the 802.1X framework (but it sure sounds friendly!).






=================
**Quiz - 11**



**An 802.1X supplicant tries to join the network and says, “Here’s my name good sir, can I come in please?” The authenticator nods and passes the message to the RADIUS server. The RADIUS server thinks for a moment and replies, “Hmm, prove it!” Which RADIUS packet type delivers this response?**

A. Access-Accept  
B. Access-Reject  
C. Access-Challenge  
D. EAPOL-Start






---

### Correct Answer:

**C. Access-Challenge**

---

### Reason:

- **Option C** is correct because the **Access-Challenge** packet is used by the RADIUS server to request additional input, such as a response to a challenge, before deciding whether the supplicant can be authenticated. It's like the server saying, "I need more proof—let’s see how you handle this challenge!"
- **Option A** is incorrect because the **Access-Accept** packet is used when the supplicant has successfully proven its identity and is granted access.
- **Option B** is incorrect because the **Access-Reject** packet is sent when authentication fails, not as part of a challenge-response process.
- **Option D** is incorrect because **EAPOL-Start** is the supplicant’s way of initiating communication, not the server's way of responding.















=================
**Quiz - 12**







**During an 802.1X deployment, a network administrator is reviewing RADIUS logs and notices two attributes: Calling-Station-Id and Called-Station-Id. If the administrator wants to identify the MAC address of the supplicant (client device) initiating the authentication, which attribute should they look at?**

A. Called-Station-Id, which contains the MAC address of the supplicant  
B. Calling-Station-Id, which contains the MAC address of the supplicant  
C. Called-Station-Id, which contains the MAC address of the authenticator  
D. Calling-Station-Id, which contains the MAC address of the authenticator








---

### Correct Answer:

**B. Calling-Station-Id, which contains the MAC address of the supplicant**

---

### Reason:

- **Option B** is correct because **Calling-Station-Id** refers to the MAC address of the supplicant (the device initiating the authentication). This attribute is used to uniquely identify the client in 802.1X communications.
- **Option A** is incorrect because **Called-Station-Id** refers to the MAC address of the authenticator (e.g., switch or access point), not the supplicant.
- **Option C** is correct in identifying what **Called-Station-Id** represents (the authenticator’s MAC address), but it is not the attribute used to identify the supplicant.
- **Option D** is incorrect because **Calling-Station-Id** does not represent the authenticator—it represents the supplicant.







=================
**Quiz - 13**



**A network administrator notices that a RADIUS server is sending a request to a switch to terminate a specific user session and remove all related session data. Which RADIUS CoA message is MOST LIKELY being used in this situation?**

A. CoA-Request  
B. Disconnect-Request  
C. CoA-ACK  
D. Disconnect-NAK









---

### Correct Answer:

**B. Disconnect-Request**

---

### Reason:

- **Option B** is correct because the **Disconnect-Request** message is specifically designed to terminate one or more user sessions on a Network Access Device (NAD) and discard all associated session data. This is commonly used when a session needs to be forcefully ended, such as during policy violations or manual intervention by an administrator.
- **Option A** is incorrect because the **CoA-Request** is used to modify or update an active session, such as reauthentication or policy changes, not to terminate a session.
- **Option C** is incorrect because the **CoA-ACK** is a response message sent by the NAD to confirm that a CoA-Request was successfully applied.
- **Option D** is incorrect because the **Disconnect-NAK** is a response message sent by the NAD when it fails to terminate the session as requested by a Disconnect-Request.








=================
**Quiz - 14**


**In a Cisco ISE deployment, a RADIUS Change of Authorization (CoA) message is sent to an authenticator to reauthenticate a client after its posture assessment is completed. However, the authenticator responds indicating it was unable to process the request. Which response is MOST LIKELY sent by the authenticator?**

A. Disconnect-ACK  
B. CoA-NAK  
C. Disconnect-NAK  
D. CoA-ACK






---

### Correct Answer:

**B. CoA-NAK**

---

### Reason:

- **Option B** is correct because the **CoA-NAK** (Negative Acknowledgment) is sent by the authenticator (e.g., switch or access point) when it fails to process a CoA-Request from the AAA server. This could occur due to issues such as invalid session identification or unsupported attributes in the CoA-Request.
- **Option A** is incorrect because the **Disconnect-ACK** is sent to confirm successful termination of a session, which is unrelated to reauthentication or CoA failures.
- **Option C** is incorrect because the **Disconnect-NAK** is sent when the authenticator is unable to terminate a session requested by a Disconnect-Request, not a CoA-Request.
- **Option D** is incorrect because the **CoA-ACK** is sent to confirm successful processing of a CoA-Request, which contradicts the scenario described.














=================
**Quiz - 15**



**During a RADIUS CoA session, the Cisco ISE server confidently tells the switch, "Hey, can you make some changes for me?" The switch proudly responds, "Got it, boss!" Which RADIUS message does the switch send back to ISE to show it successfully handled the request?**

A. CoA-ACK 
B. Disconnect-Request
C. CoA-NAK
D. Disconnect-NAK






---

### Correct Answer:

**A. CoA-ACK (Got It, Boss!)**

---

### Reason:

- **Option A** is correct because the **CoA-ACK** message is the authenticator’s way of saying, "Got it, request handled!" It confirms to the Cisco ISE server that the requested changes, such as reauthentication or policy updates, have been successfully applied.
- **Option B** is incorrect because the **Disconnect-Request** is used to terminate sessions, not confirm changes.
- **Option C** is incorrect because the **CoA-NAK** is sent when the authenticator cannot fulfill the CoA-Request, which contradicts the "Got it, boss!" scenario.
- **Option D** is incorrect because the **Disconnect-NAK** is sent when the authenticator fails to terminate a session, unrelated to CoA success.









=================
**Quiz - 16**





**Which 802.1X deployment mode allows authentication without impacting user access, enabling administrators to log and monitor device behavior before enforcing stricter policies?**

A. Low-Impact Mode  
B. Monitor Mode  
C. High-Security (Closed) Mode  
D. Flexible Authentication (FlexAuth)










### **Correct Answer:**

**B. Monitor Mode**

---

### **Reason:**

Monitor Mode allows authentication to be enabled without disrupting user access. It is effectively an "audit mode" where all devices are granted access regardless of authentication success or failure. This mode provides visibility into the network, including device behavior and authentication logs, allowing administrators to validate configurations before enforcing stricter policies.








=================
**Quiz - 17**




**In an 802.1X deployment, which feature ensures limited network access for devices when the RADIUS server is unreachable by assigning them to a pre-configured VLAN?**

A. Low-Impact Mode  
B. Critical VLAN
C. FlexAuth
D. Authentication Fail VLAN










---

### **Correct Answer:**

**B. Inaccessible Authentication Bypass (Critical VLAN)**

---

### **Reason:**

The **Inaccessible Authentication Bypass (Critical VLAN)** feature ensures that devices can still gain limited network access when the RADIUS server is unavailable. When configured, the switch moves devices to a critical data VLAN or critical voice VLAN, allowing basic connectivity while the RADIUS server issue is resolved. This helps maintain operational continuity in the event of authentication server failures.








=================
**Quiz - 18**



**An organization wants to incrementally secure its network by first allowing basic services like DHCP and DNS for unauthenticated devices but blocking access to internal resources until authentication is successful. Which 802.1X deployment mode should they implement?**

A. High-Security (Closed) Mode  
B. Low-Impact Mode  
C. Monitor (Open) Mode  
D. Multiple Authentication Mode






---

### **Correct Answer:**

**B. Low-Impact Mode**

---

### **Reason:**

The **Low-Impact Mode** is designed for environments where administrators want to provide limited connectivity (e.g., DHCP, DNS) for unauthenticated devices while preventing access to critical internal resources. This mode uses pre-authentication ACLs to allow selective traffic and dynamically applies access control (like dACLs) once authentication is successful. It offers a secure, phased transition from open access to stricter policy enforcement.







=================
**Quiz - 19**





**An administrator is deploying Cisco IBNS 2.0 and wants to dynamically assign VLANs and ACLs when a RADIUS server becomes unreachable. Which feature should be used to achieve this functionality?**

A. Pre-authentication ACL  
B. Interface Template  
C. Service Template  
D. Control Policy Rule









---

### **Correct Answer:**

**C. Service Template**

---

### **Reason:**

A **Service Template** in Cisco IBNS 2.0 is designed to dynamically assign attributes such as VLANs, ACLs, and other configurations to a session based on events. In this case, when the RADIUS server becomes unreachable, the service template can assign a critical VLAN and apply a specific ACL to ensure limited network access. This flexibility makes service templates ideal for event-driven configurations like inaccessible authentication bypass.







=================
**Quiz - 20**



**In a Cisco IBNS 2.0 deployment, what is the primary advantage of using interface templates compared to traditional per-interface configurations?**

A. They allow dynamic VLAN assignment from the RADIUS server.  
B. They enable event-based actions using service templates.  
C. They group common interface settings to reduce configuration bloat.  
D. They are required for pre-authentication ACL functionality.







---

### **Correct Answer:**

**C. They group common interface settings to reduce configuration bloat.**

---

### **Reason:**

Interface templates in Cisco IBNS 2.0 are designed to consolidate and centralize common interface configurations, such as VLAN assignments, 802.1X settings, and authentication parameters. By applying a single template to multiple interfaces, administrators can reduce repetitive configurations, simplify management, and avoid configuration bloat, especially in large-scale deployments.







=================
**Quiz - 21**







**An engineer is configuring 802.1X on a Cisco Catalyst 9800 WLC. They want to dynamically assign VLANs and apply ACLs to individual wireless clients based on attributes received from the RADIUS server. Which feature must be enabled in the policy profile to achieve this?**

A. Change of Authorization (CoA)  
B. AAA Override  
C. AAA Accounting Method List  
D. Pre-Authentication ACL







---

### **Correct Answer:**

**B. AAA Override**

---

### **Reason:**

The **AAA Override** feature in the policy profile allows the WLC to dynamically apply settings such as VLANs, QoS, and ACLs to individual clients based on RADIUS attributes returned from the AAA server (e.g., Cisco ISE). This feature is essential for enabling per-client customization and dynamic policy application, making it a critical component for 802.1X deployments with advanced requirements.






=================
**Quiz - 22**




**An administrator is configuring Cisco ISE for 802.1X authentication. They want to dynamically assign VLANs and ACLs to users based on their Active Directory group membership. Which feature must be configured in Cisco ISE to achieve this?**

A. Identity Source Sequence  
B. Authorization Profile  
C. Authentication Policy  
D. Allowed Protocols







---

### **Correct Answer:**

**B. Authorization Profile**

---

### **Reason:**

The **Authorization Profile** in Cisco ISE is used to define session permissions and attributes, such as VLAN assignments, downloadable ACLs (dACLs), and web redirection. By matching conditions like Active Directory group membership, an appropriate authorization profile can be applied to dynamically control user access levels and resources after successful authentication. This makes it the key component for implementing differentiated access based on user attributes.








=================
**Quiz - 23**



**An administrator wants to configure Cisco ISE so that employees connecting to the network using 802.1X authentication are assigned specific VLANs and dACLs based on their Active Directory group memberships. Which two components must be configured in Cisco ISE to achieve this? (Choose two.)**

A. Authentication Policy  
B. Identity Source Sequence  
C. Authorization Profile  
D. Allowed Protocols  
E. Policy Set









---

### **Correct Answer:**

**C. Authorization Profile**  
**E. Policy Set**

---

### **Reason:**

- The **Authorization Profile** is used to define session attributes such as VLAN assignments and dACLs. It ensures that users are granted access based on conditions like Active Directory group membership.
- The **Policy Set** acts as a container for authentication and authorization policies. It defines how RADIUS requests are steered and ensures that specific authorization profiles are applied based on conditions like user group, location, or access type. Together, these components allow for granular access control based on user attributes.






=================
**Quiz - 24**




**A network engineer is configuring 802.1X on a wired network using the Microsoft Windows native supplicant. To ensure security, the engineer wants to prevent rogue authentication servers from impersonating the Cisco ISE server and stealing user credentials. Which setting should the engineer enable in the supplicant configuration?**

A. Enable fallback to MAB for failed authentication.  
B. Enable server certificate validation.  
C. Enable machine authentication only.  
D. Use PEAP-MSCHAPv2 without certificate validation.











---

### **Correct Answer:**

**B. Enable server certificate validation.**

---

### **Reason:**

Enabling **server certificate validation** ensures that the client verifies the identity of the Cisco ISE server using its certificate. This cryptographic verification protects against rogue servers attempting to impersonate the legitimate authentication server and stealing user credentials. Without this setting, the supplicant may trust unverified servers, exposing the network to potential security risks.











=================
**Quiz - 25**




**An administrator is tasked with configuring 802.1X authentication for wired endpoints in an enterprise network. The requirement is to use a supplicant that supports MACsec encryption with the AES-GCM-256 algorithm for enhanced security. Which solution should the administrator deploy?**

A. Microsoft Windows native supplicant with PEAP-TLS  
B. Cisco Secure Client with Network Access Manager  
C. Microsoft Windows native supplicant with EAP-TEAP  
D. Use fallback to MAB with downloadable ACLs








---

### **Correct Answer:**

**B. Cisco Secure Client with Network Access Manager**

---

### **Reason:**

**Cisco Secure Client with Network Access Manager** supports MACsec encryption using the AES-GCM-256 algorithm, which provides robust security for wired connections. The Microsoft Windows native supplicant does not support MACsec, making Cisco Secure Client the only choice for this requirement. This ensures compliance with the organization's need for enhanced encryption on the network.





=================
**Quiz - 26**


**A network engineer is deploying Central Web Authentication (CWA) for guest access using Cisco ISE. To ensure that guest users are redirected to the guest portal upon connection, what must the engineer configure on the Cisco WLC?**

A. Enable MAC filtering and configure a redirect ACL.  
B. Configure CoA and set the NAC state to "None."  
C. Enable Layer 2 security with WPA2 and set the authentication method to MAB.  
D. Create a new WLAN with PEAP authentication and assign a VLAN for guests.






---

### **Correct Answer:**

**A. Enable MAC filtering and configure a redirect ACL.**

---

### **Reason:**

For Central Web Authentication (CWA), the **MAC filtering** setting ensures that guest devices are authenticated via MAB when they connect to the WLAN. The **redirect ACL** defines which traffic should be redirected to the Cisco ISE Guest Portal (e.g., HTTP/HTTPS traffic) and which traffic should bypass redirection (e.g., DNS, DHCP). These configurations are crucial for initiating the redirection process that leads guest users to the web portal for authentication. Other options, such as enabling WPA2 or CoA without redirection, are not appropriate for CWA



===============


